#include "af901x.h"
#include "af901x-FW.h"
//#include "MT2060M.h"
#include "FS803A.h"
#include "biu_reg.h"
#include "usb_biu_reg.h"
#include "usbdma_biu_reg.h"
#include "dummy_ram.h"
#include "error.h"
#include "define.h"

#define FW_VER 0x4410000

int dvb_usb_af901x_debug;
module_param_named(debug,dvb_usb_af901x_debug, int, 0644);
MODULE_PARM_DESC(debug, "set debugging level.(info=1,deb_fw=2,deb_fwdata=4,deb_data=8)" DVB_USB_DEBUG_STATUS);

struct usb_device *udevs;
PDEVICE_CONTEXT PDC;

RegDesc tuner_init_FreeScale_803A_EVB[] = 
#include "tuner_init_FreeScale_803A_EVB.h"
#define tuner_init_FreeScale_803A_EVB_NUM (sizeof(tuner_init_FreeScale_803A_EVB)/sizeof(tuner_init_FreeScale_803A_EVB[0]))
/*
RegDesc tuner_init_Maxlinear_MXL5003D_EVB[] = 
#include "tuner_init_Maxlinear_MXL5003D_EVB.h"
#define tuner_init_Maxlinear_MXL5003D_EVB_NUM (sizeof(tuner_init_Maxlinear_MXL5003D_EVB)/sizeof(tuner_init_Maxlinear_MXL5003D_EVB[0]))

RegDesc tuner_init_Maxlinear_MXL5005D_EVB[] = 
#include "tuner_init_Maxlinear_MXL5005D_EVB.h"
#define tuner_init_Maxlinear_MXL5005D_EVB_NUM (sizeof(tuner_init_Maxlinear_MXL5005D_EVB)/sizeof(tuner_init_Maxlinear_MXL5005D_EVB[0]))
*/

TUNER_INIT_ENTRY TunerEntry[] = {
    {TUNER_FreeScale_FS803,     0xC0,  tuner_init_FreeScale_803A_EVB_NUM,     tuner_init_FreeScale_803A_EVB_NUM, RF_IF_FS803_X100},
//    {TUNER_MAXLINEAR_MXL5003D,   0xC6,  tuner_init_Maxlinear_MXL5003D_EVB,   tuner_init_Maxlinear_MXL5003D_EVB_NUM, RF_IF_MXL5003D_X100},
//    {TUNER_MAXLINEAR_MXL5005D,   0xC6,  tuner_init_Maxlinear_MXL5005D_EVB,   tuner_init_Maxlinear_MXL5005D_EVB_NUM, RF_IF_MXL5005D_X100},
};

#define TUNER_INIT_ENTRY_NUM (sizeof(TunerEntry)/sizeof(TunerEntry[0]))



const u16 XtalVal[3] = {28800, 20480, 28000};

static u8 RegMask[8] =
{
    0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF
};


static u16 Af901xReadReg(
    u8   ucDemod2WireAddr,
    u8    ucSlaveDemod,
    u16   wRegAddr,
    u8 *  ucpValue                   // pointer to user-allocated buffer to receive data from demod
)
{
	u16    dwError = ERR_USB_NO_ERROR;

	//SysEnterCriticalSection();

	dwError = USB_ReadRegs(ucDemod2WireAddr, ucSlaveDemod, wRegAddr, 1, ucpValue);

	//SysLeaveCriticalSection();

    return (dwError);
}


static u16 Af901xReadEeprom(
    u16    wReg,
    u8 *   ucpValue
)
{
	u16   dwError = ERR_USB_NO_ERROR;
	u8    ucTemp;

	//SysEnterCriticalSection();

	dwError = Af901xReadReg(0x2a, 0,MERC_EEPROM_I2C_ADDR, &ucTemp);//MERC_EEPROM_I2C_ADDR
	if (dwError) goto exit;

    	if (ucTemp == 0)
    	{
			dwError = ERR_CANT_FIND_EEPROM;
        	goto exit;
    	}

    	dwError = USB_ReadEeprom(ucTemp, wReg, 1, ucpValue);
    	if (dwError) goto exit;

exit:
	//SysLeaveCriticalSection();
	return(dwError);
}

static u32 Af901xLoadFW(
    u8	ucDemod2WireAddr // apiremove comma
)
{
    u32  dwError = ERR_NO_ERROR;
    u32 dwLen = 0;
    u8 * ucpFwArray;

    dwLen = sizeof(packetArr) / sizeof(u8);  // api_usb_only
    ucpFwArray = (u8 *)packetArr;            // api_usb_only

    //SysEnterCriticalSection();

    dwError = USB_DownloadFw(ucDemod2WireAddr, dwLen, ucpFwArray);

    //SysLeaveCriticalSection();

    return (dwError);
}

static u32 Af901xGetFwVersion(
    u8	ucDemod2WireAddr,
    u8	ucSlaveDemod,
    u32 *    dwpVer
)
{
    u32   dwError = ERR_NO_ERROR;
    u8    ucTemp0;
    u8    ucTemp1;
    u8    ucTemp2;
    u8    ucTemp3;

    dwError = Af901xReadReg(ucDemod2WireAddr, ucSlaveDemod, MERC_ADDR_FW_VER, &ucTemp3);
    if (dwError) goto exit;
    dwError = Af901xReadReg(ucDemod2WireAddr, ucSlaveDemod, MERC_ADDR_FW_VER + 1, &ucTemp2);
    if (dwError) goto exit;
    dwError = Af901xReadReg(ucDemod2WireAddr, ucSlaveDemod, MERC_ADDR_FW_VER + 2, &ucTemp1);
    if (dwError) goto exit;
    dwError = Af901xReadReg(ucDemod2WireAddr, ucSlaveDemod, MERC_ADDR_FW_VER + 3, &ucTemp0);
    if (dwError) goto exit;
    
    *dwpVer = (u32)((ucTemp3 << 24) + (ucTemp2 << 16) + (ucTemp1 << 8) + ucTemp0);

exit:
    return(dwError);
}

static u32 Af901xWriteReg(
    u8    ucDemod2WireAddr,      // demod 2-Wire bus address (only for AF9013 mode)
    u8    ucSlaveDemod,          // 1 for slave demod of AF9015 + AF9013, 0 otherwise
    u16   wRegAddr,              // register address
    u8    ucValue                // value to write to demod
)
{
    u32   dwError = ERR_NO_ERROR;

	//SysEnterCriticalSection();
        
    dwError = USB_WriteRegs(ucDemod2WireAddr, ucSlaveDemod, wRegAddr, 1, &ucValue);
       
	//SysLeaveCriticalSection();
    
    return (dwError);
}

//static u32 Af901xWriteRegBits(
extern u32 Af901xWriteRegBits(
    u8    ucDemod2WireAddr,
    u8    ucSlaveDemod,
    u16   wRegAddr,              // register address
    u8    ucPos,                 // start bit to write
    u8    ucLen,                 // number of bits to write
    u8    ucValue                // value to write to register
)
{
    u32    dwError = ERR_NO_ERROR;
    u8     ucTemp;

    dwError = Af901xReadReg(ucDemod2WireAddr, ucSlaveDemod, wRegAddr, &ucTemp);
    if (dwError) goto exit;

    ucTemp = REG_CREATE(ucValue, ucTemp, ucPos, ucLen, RegMask);
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, wRegAddr, ucTemp);
    goto exit;

exit:
    return (dwError);
}

static u32 Af901xReadRegBits(
    u8    ucDemod2WireAddr,
    u8    ucSlaveDemod,
    u16   wRegAddr,
    u8    ucPos,
    u8    ucLen,
    u8 *  ucpValue
)
{
    u32    dwError = ERR_NO_ERROR;
    u8     ucTemp;

    dwError = Af901xReadReg(ucDemod2WireAddr, ucSlaveDemod, wRegAddr, &ucTemp);
    if (dwError) goto exit;

    ucTemp = REG_GET(ucTemp, ucPos, ucLen, RegMask);
	*ucpValue = ucTemp;

exit:
    return (dwError);
}

static u16 DRV_GetEEPROMConfig(u8 tmp)
{
	
	u16  dwError= ERR_USB_NO_ERROR;
    u8 btmp;

   
    //bIrTblDownload option
    dwError = Af901xReadEeprom(EEPROM_IRMODE, &btmp);
    if (dwError) goto exit;
	deb_data("EEPROM_IRMODE = 0x%02X\n", btmp);
    PDC->bIrTblDownload = btmp;

    //bDualTs option
    dwError = Af901xReadEeprom(EEPROM_TSMODE, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_TSMODE = 0x%02X\n", btmp);
    PDC->bDualTs = btmp;

    //MPEG2 I2C Addr option
    dwError = Af901xReadEeprom(EEPROM_2WIREADDR, &btmp);
    if (dwError){
       	PDC->ucDemod2WireAddr = SLAVE_DEMOD_2WIREADDR;
		deb_data("EEPROM_2WIREADDR Fail\n");
       	goto exit;
    }
    deb_data("EEPROM_2WIREADDR = 0x%02X\n", btmp);
    PDC->ucDemod2WireAddr = btmp;

exit:
    return(dwError);     
}

static u16 DRV_GetEEPROMConfig2(u8 ucSlaveDemod)
{
	u16	dwError = ERR_NO_ERROR;
	u16	shift = 0;
	u8	btmp;

    if(ucSlaveDemod)  shift = EEPROM_SHIFT;
     //Saw Bandwidth option
    dwError = Af901xReadEeprom(EEPROM_SAWBW1+shift, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_SAWBW%d = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.SawBw = btmp;  

    //bClk2048 option	
    dwError = Af901xReadEeprom(EEPROM_XTAL1+shift, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_XTAL%d  = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.XtalType = btmp;  

    //bMT2060 option
    dwError = Af901xReadEeprom(EEPROM_TUNERID+shift, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_TUNERID%d  = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.TunerId = btmp;  
        
    //get IF Freq        
    //ifFreqh        
    dwError = Af901xReadEeprom(EEPROM_IFFREQH+shift, &btmp);
    if (dwError) goto exit;       
    deb_data("EEPROM_IFFREQH%d  = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.wIfFreq = btmp;
    PDC->fc.tunerinfo.wIfFreq <<= 8;
    
    //ifFreql
    dwError = Af901xReadEeprom(EEPROM_IFFREQL+shift, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_IFFREQL%d  = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.wIfFreq += btmp;    
    deb_data("pdc->wIfFreq%d  = 0x%04X\n",ucSlaveDemod, PDC->fc.tunerinfo.wIfFreq);
    
    //get IF1 Freq
    //if1h        
    dwError = Af901xReadEeprom(EEPROM_IF1H+shift, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_IF1H%d  = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.wIf1 = btmp;
    PDC->fc.tunerinfo.wIf1 <<= 8;
    
    //if1l
    dwError = Af901xReadEeprom(EEPROM_IF1L+shift, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_IF%d L = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.wIf1 += btmp;
    deb_data("Pdc.wIf%d  = 0x%04X\n",ucSlaveDemod, PDC->fc.tunerinfo.wIf1);
    
    //get RF spec inv
    dwError = Af901xReadEeprom(EEPROM_SPECINV1+shift, &btmp);
    if (dwError) goto exit;
    deb_data("EEPROM_SPECINV%d  = 0x%02X\n",ucSlaveDemod, btmp);
    PDC->fc.tunerinfo.bRdSpecInv = btmp;    
    deb_data("RF Spec Inv = %d \n",PDC->fc.tunerinfo.bRdSpecInv);

exit:
    return(dwError);     
}

u32 DRV_InitTunerInfo(u8 ucSlaveDemod)
{
    PDC->fc.tunerinfo.tunerAddress = 0xC0;
    PDC->fc.tunerinfo.bInitTuner = true;
    PDC->fc.tunerinfo.bSetFreq = false;

    //For MxL Tuner
    PDC->fc.tunerinfo.LastChannel = 0;
    //For QT1010 Tuner
    PDC->fc.tunerinfo.PCBType = 0x18;

    return ERR_NO_ERROR;
}


static void DRV_GetTunerIdx(u8 ucSlaveDemod)
{
    u8 tunerId;
    int  tunerIdx,i; 

    tunerId = PDC->fc.tunerinfo.TunerId;
    tunerIdx = -1;  

    for (i=0; i<TUNER_INIT_ENTRY_NUM; i++) {
        if (tunerId == TunerEntry[i].tunerId) { 
            tunerIdx = i;          
            break;
        }         
    }
	tunerIdx=0;
    printk(KERN_NOTICE"tunerIdx = %d, tunerId = %d", tunerIdx, tunerId);
    if (tunerIdx < 0)
        deb_data("Cannot find the corresponding initscript!");
    
    PDC->fc.tunerinfo.tunerIdx = tunerIdx;
    DRV_InitTunerInfo(ucSlaveDemod);
}    

static u16 DL_GetEEPROMConfig(u8 tmp)
{

	u16 dwError;
    u8 ucSlaveDemod=0;

	dwError = DRV_GetEEPROMConfig(1);
    if (dwError) goto exit;
    //ENTER_MUTEX();  
	dwError = DRV_GetEEPROMConfig2(ucSlaveDemod);
    if (dwError) goto exit;
    
	//dwError = DRV_InitDevInfo(intf, ucSlaveDemod);
    //if (dwError) goto exit;
    DRV_GetTunerIdx(ucSlaveDemod);

exit://LEAVE_MUTEX();    
    return(dwError);
}

static u32 DRV_GetFwVersions(
    u32 *pVer
)
{
    u32   dwError = ERR_NO_ERROR;        
    u8    ucDemod2WireAddr = 0x3A;
    u8    ucSlaveDemod = 0;    

    dwError = Af901xGetFwVersion(ucDemod2WireAddr, ucSlaveDemod, pVer);

    return(dwError);  
    
}

static u32 DRV_TsInit(u8 tmp)
{       
    u32   dwError = ERR_NO_ERROR;   
    u8    ucDemod2WireAddr = PDC->ucDemod2WireAddr;
    u8    ucSlaveDemod = 0;
    
    //assert EP4 reset
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_mp2_sw_rst, reg_mp2_sw_rst_pos, reg_mp2_sw_rst_len, 1);
    if (dwError) goto exit;
    
    //assert EP5 reset
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_mp2if2_sw_rst, reg_mp2if2_sw_rst_pos, reg_mp2if2_sw_rst_len, 1);
    if (dwError) goto exit; 
    
    //disable EP4
    deb_data("disable EP4\n"); 
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep4_tx_en, reg_ep4_tx_en_pos, reg_ep4_tx_en_len, 0);
    if (dwError) goto exit;
    
    //disable EP5
    deb_data("disable EP5\n");
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep5_tx_en, reg_ep5_tx_en_pos, reg_ep5_tx_en_len, 0);          
    if (dwError) goto exit;
    
    //enable EP4
    deb_data("enable EP4\n"); 
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep4_tx_en, reg_ep4_tx_en_pos, reg_ep4_tx_en_len, 1);
    if (dwError) goto exit;
    
    //disable EP5
    deb_data("disable EP5\n");
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep5_tx_en, reg_ep5_tx_en_pos, reg_ep5_tx_en_len, 0);   
    if (dwError) goto exit;    
      
    deb_data("disable EP4 NAK\n"); 
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep4_tx_nak, reg_ep4_tx_nak_pos, reg_ep4_tx_nak_len, 0);
    if (dwError) goto exit; 

    deb_data("disable 15 SER/PAR mode\n"); 
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_mp2if_mpeg_par_mode, mp2if_mpeg_par_mode_pos, mp2if_mpeg_par_mode_len, 0);
    if (dwError) goto exit; 
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_mp2if_mpeg_ser_mode, mp2if_mpeg_ser_mode_pos, mp2if_mpeg_ser_mode_len, 0);
    if (dwError) goto exit; 

    //EP4 xfer length
	PDC->TsFrameSize=512*188;
    deb_data("set EP4 xferLen = %d\n", PDC->TsFrameSize);  
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep4_tx_len_7_0, (u8)PDC->TsFrameSizeDw);
    if (dwError) goto exit; 
    
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep4_tx_len_15_8, (u8)(PDC->TsFrameSizeDw>>8));
    if (dwError) goto exit;

    //EP4 packet size
    deb_data("set EP4 MaxPacketSize = %d\n", PDC->MaxPacketSize); 
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_ep4_max_pkt, PDC->MaxPacketSize/4);
    if (dwError) goto exit;

    //disable mp2if2
    deb_data("disable mp2if2\n"); 
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_mp2if2_en, reg_mp2if2_en_pos, reg_mp2if2_en_len, 0);       
    if (dwError) goto exit;  

    //negate EP4 reset
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_mp2_sw_rst, reg_mp2_sw_rst_pos, reg_mp2_sw_rst_len, 0);
    if (dwError) goto exit;
    
    //negate EP5 reset
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_mp2if2_sw_rst, reg_mp2if2_sw_rst_pos, reg_mp2if2_sw_rst_len, 0);
    if (dwError) goto exit;  
 
            
exit:
    return(dwError);
    
}

u32 DL_MercuryInit(u8 tmp)
{    
    //ENTER_MUTEX();
    
    u32 dwError = ERR_NO_ERROR;
	
    dwError = DRV_TsInit(1);

    if (dwError) {
        deb_data("DRV_TsInit Fail: 0x%04x\n", dwError); 
        goto exit;     
     }


exit:	  
    //LEAVE_MUTEX();    
    
    return(dwError);     
} 
EXPORT_SYMBOL(DL_MercuryInit);

static u32 Af901xOnOffTuner(
    u8  ucDemod2WireAddr,
    u8	ucOn
)
{
    u32	dwError = ERR_NO_ERROR;
    u8	ucTemp;
    deb_data("enter Af901xOnOffTuner: %s\n",(ucOn==1)?"ON":"OFF");

    if (ucOn)
    {
        ucTemp = 3;
    }
    else
    {
        ucTemp = 7;
    }

    dwError = Af901xWriteRegBits( ucDemod2WireAddr, 0, xd_p_reg_top_gpio3on, reg_top_gpio3on_pos, 3, ucTemp);

    return (dwError);
}


u32 DRV_TunerPowerCtrl(u8 bPowerOn)
{
    u32   dwError = ERR_NO_ERROR;
    u8    ucDemod2WireAddr = 0x3A;
    deb_data("enter DRV_TunerPowerCtrl\n");

    dwError = Af901xOnOffTuner(ucDemod2WireAddr,bPowerOn);

    return(dwError);
}
EXPORT_SYMBOL(DRV_TunerPowerCtrl);


static u32 DRV_Lock1LedCtrl (	
    u8	bOn
)
{
    u32 dwError = ERR_NO_ERROR;
    u8  ucDemod2WireAddr = 0x3A;
    u8  ucSlaveDemod = 0;
    deb_data("enter DRV_Lock1LedCtrl\n"); 

    if(bOn)
    {
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_top_lock1out, reg_top_lock1out_pos, reg_top_lock1out_len, 1);
        if (dwError) goto exit;
        
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_top_lock1out, reg_top_lock1_tpsd_pos, reg_top_lock1_tpsd_len, 0);    
    }
    else
    {
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, xd_p_reg_top_lock1out, reg_top_lock1out_pos, reg_top_lock1out_len, 0);
    }

exit:    

    return(dwError);
}    

static u32 Af901xSwPowerCtrl(	
    u8	ucCtrl
)
{
    u32	dwError = ERR_NO_ERROR;
    u8	ucDemod2WireAddr = 0x3A;
    u8	ucSlaveDemod = 0;
    u32	i;
    u8	ucTemp;

    deb_data("Enter Af901xSwPowerCtrl:%d\n", ucCtrl); 

    if (ucCtrl)         // power up case
    {
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_reg_afe_mem0, 3, 1, 0);
        if (dwError) goto exit;

        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, I2C_reg_ofdm_rst, reg_ofdm_rst_pos, reg_ofdm_rst_len, 0);
        if (dwError) goto exit;

        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, I2C_reg_ofdm_rst_en, reg_ofdm_rst_en_pos, reg_ofdm_rst_en_len, 0);
        if (dwError) goto exit;

    }
    else                // power down case
    {
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, I2C_reg_ofdm_rst_en, reg_ofdm_rst_en_pos, reg_ofdm_rst_en_len, 1);
        if (dwError) goto exit;

        dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, AF901X_REG_RESET, 1);
        if (dwError) goto exit;

        for (i = 0; i < 150; i++)
        {
            dwError = Af901xReadRegBits(ucDemod2WireAddr, ucSlaveDemod, I2C_reg_ofdm_rst, reg_ofdm_rst_pos, reg_ofdm_rst_len, &ucTemp);
            if (dwError)
            {
                deb_data("fail to Clear ofdm reset\n");
                goto exit;
            }
		    if (ucTemp) break;

            msleep(10);
        }

        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_reg_afe_mem0, 3, 1, 1);
        if (dwError) goto exit;
    }

exit:
    return (dwError);
}


u32 MyDivider(u32 a, u32 b, u32 x)
{
    u32 answer = 0;
    u32 c = 0;
    u32 i = 0;

    if (a > b)
    {
        c = a / b;
        a = a - c * b;
    }

    for (i = 0; i < x; i++)
    {
        if (a >= b)
        {
            answer += 1;
            a-=b;
        }
        a<<=1;
        //if (i < (x -1))
        {
            answer <<= 1;
        }
    }

    answer = (c << (int)x) + answer;

    return (answer);
}

static u32 ComputeAdc(
    int        iFs,               // ADC frequency (KHz)
    u32 *    dwpAdc
)
{
    u32   dwError = ERR_NO_ERROR;

    int    adc_freq;           // Hz
    int    adc;

    adc_freq = iFs * 1000;
    adc = (int)MyDivider((u32)adc_freq, 1000000ul, 19ul);

    *dwpAdc = adc;

    return (dwError);
}


static u32 ComputeFcw(
    int        iFs,                // ADC frequency (KHz)
    int        iIf,                // IF frequency (KHz)
    u8       ucSpecInv,          // RF spectrum inversion
    u32 *    dwpFcw
)
{
    u32   dwError = ERR_NO_ERROR;

    int        if_freq;
    int        adc_freq;
    u8       spec_inv;
    int        adc_freq_half;
    int        f_if_sample;
    int        bfs_Spec_inv;
    int        fcw;

    adc_freq        = iFs * 1000;
    if_freq         = iIf * 1000;
    adc_freq_half   = adc_freq / 2;

    if (ucSpecInv)
    {
        spec_inv = 1;
    }
    else
    {
        spec_inv = 0;
    }

    if (spec_inv == 1)
    {
        if_freq = -1 * if_freq;
    }

    f_if_sample = if_freq;

    if (f_if_sample >= 0)
    {
        bfs_Spec_inv = 1;
    }
    else
    {
        bfs_Spec_inv = -1;
        f_if_sample = f_if_sample*-1;
    }

    while(f_if_sample > adc_freq_half)
    {
        f_if_sample = f_if_sample - adc_freq;
    }

    
    if(f_if_sample >=0) // sample, spectrum at positive frequency
    {
        bfs_Spec_inv = bfs_Spec_inv*-1;
    }
    else
    {
        bfs_Spec_inv = bfs_Spec_inv*1;
        f_if_sample = f_if_sample * (-1);       // abs
    }

    fcw = (int)MyDivider((u32)f_if_sample, (u32)adc_freq, 23ul);

    if(bfs_Spec_inv==-1)
    {
        fcw = 0x00800000 - fcw;
    }

    fcw = fcw & 0xFFFFFF;

    *dwpFcw = fcw;

    return (dwError);
}


static u32 Af901xLoadFcwAdc(
    u8    ucDemod2WireAddr,
    u8    ucSlaveDemod,
    int   iFsFreq,            // ADC frequency (KHz)
    int   iIfFreq,            // IF frequency (KHz)
    u8    ucSpecInv           // Spectrum inverse in RF
)
{
    u32  dwError = ERR_NO_ERROR;
    u32  dwFcw = 0;
    u32  dwAdc = 0;
    u8   ucAdcFreqType = 0;
    u8   ucOtherSpecInv = 0;
    
    dwError = ComputeAdc(iFsFreq, &dwAdc);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_f_adc_7_0, (u8)(dwAdc & 0x000000FF));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_f_adc_15_8, (u8)((dwAdc & 0x0000FF00) >> 8));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_f_adc_23_16, (u8)((dwAdc & 0x00FF0000) >> 16));
    if (dwError) goto exit;

    if (iFsFreq == 28800)
    {
        ucAdcFreqType = 0;
    }
    else if (iFsFreq == 20480)
    {
        ucAdcFreqType = 1;
    }
    else if (iFsFreq == 28000)
    {
        ucAdcFreqType = 2;
    }
    else if (iFsFreq == 25000)
    {
        ucAdcFreqType = 3;
    }
    else
    {
        dwError = ERR_INVALID_XTAL_FREQ;
        goto exit;
    }

    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_dummy_fadc_type, dummy_fadc_type_pos, dummy_fadc_type_len, ucAdcFreqType);
    if (dwError) goto exit;    
    
    dwError = ComputeFcw(iFsFreq, iIfFreq, ucSpecInv, &dwFcw);
    if (dwError) goto exit;

    //gdwOrigFCW[ucSlaveDemod] = dwFcw;
    PDC->fc.gdwOrigFCW = dwFcw;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_bfs_fcw_7_0, (u8)(dwFcw & 0x000000FF));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_bfs_fcw_15_8, (u8)((dwFcw & 0x0000FF00) >> 8));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_bfs_fcw_22_16, (u8)((dwFcw & 0x007F0000) >> 16));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_bfs_fcw_def_7_0, (u8)(dwFcw & 0x000000FF));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_bfs_fcw_def_15_8, (u8)((dwFcw & 0x0000FF00) >> 8));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_bfs_fcw_def_22_16, (u8)((dwFcw & 0x007F0000) >> 16));
    if (dwError) goto exit;

    ucOtherSpecInv = ucSpecInv ? 0 : 1;

    dwError = ComputeFcw(iFsFreq, iIfFreq, ucOtherSpecInv, &dwFcw);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_bfs_fcw_inv_7_0, (u8)(dwFcw & 0x000000FF));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_bfs_fcw_inv_15_8, (u8)((dwFcw & 0x0000FF00) >> 8));
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_bfs_fcw_inv_22_16, (u8)((dwFcw & 0x007F0000) >> 16));
    if (dwError) goto exit;
    
exit:
    return (dwError);
}

static u32 Af901xProgramCFOE(
    u8        ucDemod2WireAddr,
    u8        ucSlaveDemod,
    u8        ucBw,
    u32       dwXtalFreq         // crystal frequency in unit of kHz
)
{
    u32      dwError = ERR_NO_ERROR;
    
	u32		NS_coeff1_2048Nu;
	u32		NS_coeff1_8191Nu;
	u32		NS_coeff1_8192Nu;
	u32		NS_coeff1_8193Nu;
	u32		NS_coeff2_2k;
	u32		NS_coeff2_8k;

    u8		ucTemp0;
	u8		ucTemp1;
	u8		ucTemp2;
	u8		ucTemp3;
    u8      buf[4];

    switch(dwXtalFreq)
	{
     	case 28800:  //28.8MHz
     	    if (ucBw == 6)
             {
                NS_coeff1_2048Nu = 0x01e79e7a;
     	        NS_coeff1_8191Nu = 0x0079eb6e;
     	        NS_coeff1_8192Nu = 0x0079e79e;
     	        NS_coeff1_8193Nu = 0x0079e3cf;
     	        NS_coeff2_2k = 0x00f3cf3d;
     	        NS_coeff2_8k = 0x003cf3cf;
             }
             else if (ucBw == 7)
             {
                NS_coeff1_2048Nu = 0x0238e38e;
     	        NS_coeff1_8191Nu = 0x008e3d55;
     	        NS_coeff1_8192Nu = 0x008e38e4;
     	        NS_coeff1_8193Nu = 0x008e3472;
     	        NS_coeff2_2k     = 0x011c71c7;
     	        NS_coeff2_8k     = 0x00471c72;
             }
             else if (ucBw == 8)
             {
                NS_coeff1_2048Nu = 0x028a28a3;
     	        NS_coeff1_8191Nu = 0x00a28f3d;
     	        NS_coeff1_8192Nu = 0x00a28a29;
     	        NS_coeff1_8193Nu = 0x00a28514;
     	        NS_coeff2_2k     = 0x01451451;
     	        NS_coeff2_8k     = 0x00514514;
             }
             else
             {
                 dwError = ERR_INVALID_BW;
                 goto exit;
             }
            break;    

        case 20480:  // 20.48 MHz    
            if (ucBw == 6)
            {
                NS_coeff1_2048Nu = 0x2ADB6DC;
                NS_coeff1_8191Nu = 0xAB7313;
                NS_coeff1_8192Nu = 0xAB6DB7;
                NS_coeff1_8193Nu = 0xAB685C;
                NS_coeff2_2k     = 0x156DB6E;
                NS_coeff2_8k     = 0x55B6DC;
            }
            else if (ucBw == 7)
            {
                NS_coeff1_2048Nu = 0x3200001;
                NS_coeff1_8191Nu = 0xC80640;
                NS_coeff1_8192Nu = 0xC80000;
                NS_coeff1_8193Nu = 0xC7F9C0;
                NS_coeff2_2k     = 0x1900000;
                NS_coeff2_8k     = 0x640000;
            }
            else if (ucBw == 8)
            {
                NS_coeff1_2048Nu = 0x3924926;
                NS_coeff1_8191Nu = 0xE4996E;
                NS_coeff1_8192Nu = 0xE49249;
                NS_coeff1_8193Nu = 0xE48B25;
                NS_coeff2_2k     = 0x1C92493;
                NS_coeff2_8k     = 0x724925;
            }
            else
            {
                dwError = ERR_INVALID_BW;
                goto exit;
            }
            break;

        case 28000:  //28.0MHz
            if (ucBw == 6)
            {
                NS_coeff1_2048Nu = 0x01F58D10;
                NS_coeff1_8191Nu = 0x007D672F;
                NS_coeff1_8192Nu = 0x007D6344;
                NS_coeff1_8193Nu = 0x007D5F59;
                NS_coeff2_2k     = 0x00FAC688;
                NS_coeff2_8k     = 0x003EB1A2;
            }
            else if (ucBw == 7)
            {
                NS_coeff1_2048Nu = 0x02492492;
                NS_coeff1_8191Nu = 0x00924DB7;
                NS_coeff1_8192Nu = 0x00924925;
                NS_coeff1_8193Nu = 0x00924492;
                NS_coeff2_2k     = 0x01249249;
                NS_coeff2_8k     = 0x00492492;
            }
            else if (ucBw == 8)
            {
                NS_coeff1_2048Nu = 0x029CBC15;
                NS_coeff1_8191Nu = 0x00A7343F;
                NS_coeff1_8192Nu = 0x00A72F05;
                NS_coeff1_8193Nu = 0x00A729CC;
                NS_coeff2_2k     = 0x014E5E0A;
                NS_coeff2_8k     = 0x00539783;
            }
            else
            {
                dwError = ERR_INVALID_BW;
                goto exit;
            }
            break;    

        case 25000:  //25.0MHz
    	    if (ucBw == 6)
            {
                NS_coeff1_2048Nu = 0x0231BCB5;
    	        NS_coeff1_8191Nu = 0x008C7391;
    	        NS_coeff1_8192Nu = 0x008C6F2D;
    	        NS_coeff1_8193Nu = 0x008C6ACA;
    	        NS_coeff2_2k = 0x0118DE5B;
    	        NS_coeff2_8k = 0x00463797;
            }
            else if (ucBw == 7)
            {
                NS_coeff1_2048Nu = 0x028F5C29;
    	        NS_coeff1_8191Nu = 0x00A3DC29;
    	        NS_coeff1_8192Nu = 0x00A3D70A;
    	        NS_coeff1_8193Nu = 0x00A3D1EC;
    	        NS_coeff2_2k     = 0x0147AE14;
    	        NS_coeff2_8k     = 0x0051EB85;
            }
            else if (ucBw == 8)
            {
                NS_coeff1_2048Nu = 0x02ECFB9D;
    	        NS_coeff1_8191Nu = 0x00BB44C1;
    	        NS_coeff1_8192Nu = 0x00BB3EE7;
    	        NS_coeff1_8193Nu = 0x00BB390D;
    	        NS_coeff2_2k     = 0x01767DCE;
    	        NS_coeff2_8k     = 0x005D9F74;
            }
            else
            {
                dwError = ERR_INVALID_BW;
                goto exit;
            }
            break;    

        default:
            dwError = ERR_INVALID_XTAL_FREQ;
            goto exit;
    }

    // get tBYTE0
    ucTemp0 = (u8)(NS_coeff1_2048Nu & 0x000000FF);

	// get tBYTE1
	ucTemp1 = (u8)((NS_coeff1_2048Nu & 0x0000FF00) >> 8);

	// get tBYTE2
	ucTemp2 = (u8)((NS_coeff1_2048Nu & 0x00FF0000) >> 16);

	// get tBYTE3[1:0]
	// Bit[7:2] will be written soon and so don't have to care them
	ucTemp3 = (u8)((NS_coeff1_2048Nu & 0x03000000) >> 24);

    // big endian to make 8051 happy
    buf[0] = ucTemp3;
    buf[1] = ucTemp2;
    buf[2] = ucTemp1;
    buf[3] = ucTemp0;

    // cfoe_NS_2k_coeff1_25_24
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE00, buf[0]);
    if (dwError) goto exit;

    // cfoe_NS_2k_coeff1_23_16
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE01, buf[1]);
    if (dwError) goto exit;

    // cfoe_NS_2k_coeff1_15_8
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE02, buf[2]);
    if (dwError) goto exit;

    // cfoe_NS_2k_coeff1_7_0
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE03, buf[3]);
    if (dwError) goto exit;

    // get tBYTE0
    ucTemp0 = (u8)((NS_coeff2_2k & 0x0000003F));

	// get tBYTE1
	ucTemp1 = (u8)((NS_coeff2_2k & 0x00003FC0) >> 6);

	// get tBYTE2
	ucTemp2 = (u8)((NS_coeff2_2k & 0x003FC000) >> 14);

	// get tBYTE3
	ucTemp3 = (u8)((NS_coeff2_2k & 0x01C00000) >> 22);

    // big endian to make 8051 happy
    buf[0] = ucTemp3;
    buf[1] = ucTemp2;
    buf[2] = ucTemp1;
    buf[3] = ucTemp0;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE04, buf[0]);
    if (dwError) goto exit;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE05, buf[1]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE06, buf[2]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE07, buf[3]);
    if (dwError) goto exit;

    // get tBYTE0
    ucTemp0 = (u8)((NS_coeff1_8191Nu & 0x000000FF));

	// get tBYTE1
	ucTemp1 = (u8)((NS_coeff1_8191Nu & 0x0000FF00) >> 8);

	// get tBYTE2
	ucTemp2 = (u8)((NS_coeff1_8191Nu & 0x00FFC000) >> 16);

	// get tBYTE3
	ucTemp3 = (u8)((NS_coeff1_8191Nu & 0x03000000) >> 24);

    // big endian to make 8051 happy
    buf[0] = ucTemp3;
    buf[1] = ucTemp2;
    buf[2] = ucTemp1;
    buf[3] = ucTemp0;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE08, buf[0]);
    if (dwError) goto exit;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE09, buf[1]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE0A, buf[2]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE0B, buf[3]);
    if (dwError) goto exit;

    // get tBYTE0
    ucTemp0  = (u8)(NS_coeff1_8192Nu & 0x000000FF);

	// get tBYTE1
	ucTemp1 = (u8)((NS_coeff1_8192Nu & 0x0000FF00) >> 8);

	// get tBYTE2
	ucTemp2 = (u8)((NS_coeff1_8192Nu & 0x00FFC000) >> 16);

	// get tBYTE3
	ucTemp3 = (u8)((NS_coeff1_8192Nu & 0x03000000) >> 24);

    // big endian to make 8051 happy
    buf[0] = ucTemp3;
    buf[1] = ucTemp2;
    buf[2] = ucTemp1;
    buf[3] = ucTemp0;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE0C, buf[0]);
    if (dwError) goto exit;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE0D, buf[1]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE0E, buf[2]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE0F, buf[3]);
    if (dwError) goto exit;

    // get tBYTE0
    ucTemp0 = (u8)((NS_coeff1_8193Nu & 0x000000FF));

	// get tBYTE1
	ucTemp1 = (u8)((NS_coeff1_8193Nu & 0x0000FF00) >> 8);

	// get tBYTE2
	ucTemp2 = (u8)((NS_coeff1_8193Nu & 0x00FFC000) >> 16);

	// get tBYTE3
	ucTemp3 = (u8)((NS_coeff1_8193Nu & 0x03000000) >> 24);

    // big endian to make 8051 happy
    buf[0] = ucTemp3;
    buf[1] = ucTemp2;
    buf[2] = ucTemp1;
    buf[3] = ucTemp0;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE10, buf[0]);
    if (dwError) goto exit;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE11, buf[1]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE12, buf[2]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE13, buf[3]);
    if (dwError) goto exit;

    // get tBYTE0
    ucTemp0 = (u8)((NS_coeff2_8k & 0x0000003F));

	// get tBYTE1
	ucTemp1 = (u8)((NS_coeff2_8k & 0x00003FC0) >> 6);

	// get tBYTE2
	ucTemp2 = (u8)((NS_coeff2_8k & 0x003FC000) >> 14);

	// get tBYTE3
	ucTemp3 = (u8)((NS_coeff2_8k & 0x01C00000) >> 22);

    // big endian to make 8051 happy
    buf[0] = ucTemp3;
    buf[1] = ucTemp2;
    buf[2] = ucTemp1;
    buf[3] = ucTemp0;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE14, buf[0]);
    if (dwError) goto exit;

	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE15, buf[1]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE16, buf[2]);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAE17, buf[3]);

exit:
	return(dwError);
}


u32 Af901xSelectBW (
    u8  ucDemod2WireAddr,
    u8  ucSlaveDemod,
    u8	ucBw,               // MHz
    u32	dwFs                // KHz, ex: 28800
)
{
    u32   dwError = ERR_NO_ERROR;
    u8    bw;

    deb_data("enter Af901xSelectBW: %d\n", ucBw);

	if (ucBw == 6)
    {
        bw = 0;
    }
    else if (ucBw == 7)
    {
        bw = 1;
    }
    else if (ucBw == 8)
    {
        bw = 2;
    }
    else
    {
        dwError = ERR_INVALID_BW;
        goto exit;
    }
    deb_data("1enter Af901xSelectBW: %d\n", ucBw);
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_bw, reg_bw_pos, reg_bw_len, bw);
    if (dwError) goto exit;
    deb_data("2enter Af901xSelectBW: %d\n", ucBw);
    dwError = Af901xProgramCFOE(ucDemod2WireAddr, ucSlaveDemod, ucBw, dwFs);
    deb_data("3enter Af901xSelectBW: %d\n", ucBw);
exit:
	return(dwError);
}
EXPORT_SYMBOL(Af901xSelectBW);


u32 Af901xEnableFecMon(
    u8	ucDemod2WireAddr,
    u8  ucSlaveDemod
)
{
    u32   dwError = ERR_NO_ERROR;

	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_fec_vtb_rsd_mon_en, fec_vtb_rsd_mon_en_pos, fec_vtb_rsd_mon_en_len, 1);
    if (dwError) goto exit;

exit:
    return(dwError);
}

u32 DRV_InitTuner(
    u8        ucDemod2WireAddr,
    u8        ucSlaveDemod,
    u8        ucTuner2WireAddr,
    void *      pTunerData
)
{
    u32   dwError = ERR_NO_ERROR;
	int tunerIdx = 1;//PDC->fc.tunerinfo.tunerIdx; 
	ucSlaveDemod=0;
	ucDemod2WireAddr=0x3A;
	ucTuner2WireAddr=0xC0;

	if (tunerIdx < 0) {
        dwError = ERR_INVALID_TUNER_TYPE;        
        goto exit;    
	}

	dwError = InitFS803((Handle_t)1,ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, pTunerData);
    //dwError = TunerEntry[tunerIdx].Initfunc(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, pTunerData);
    if (dwError){
        deb_data("Init Tuner Fail\n");
        goto exit;
    }

exit:
    return (dwError);    
}

u32 DRV_SetTuner(
    u8        ucDemod2WireAddr,
    u8        ucSlaveDemod,
    u8        ucTuner2WireAddr,
    u32       dwFreq,
    u8        ucBw
)
{

    u8   dwError = ERR_NO_ERROR;
    int tunerIdx =PDC->fc.tunerinfo.tunerIdx; 	
	ucSlaveDemod=0;
	ucDemod2WireAddr=0x3A;
	ucTuner2WireAddr=0xC0;
	deb_data("%s\n",__FUNCTION__);

    if (tunerIdx < 0) {
        dwError = ERR_INVALID_TUNER_TYPE;        
        goto exit;    
    }

	dwError = SetFS803((Handle_t)1,ucDemod2WireAddr,ucSlaveDemod,ucTuner2WireAddr,dwFreq,ucBw);
    //dwError = TunerEntry[tunerIdx].func(ucDemod2WireAddr,ucSlaveDemod,ucTuner2WireAddr,dwFreq,ucBw);
    if (dwError) {
        deb_data("SetTuner FAIL!\n");
        goto exit;
    }      
    
exit:
    return (dwError);    
}      


u32 DRV_AdjustTuner(
    u8        ucDemod2WireAddr,    
    u8        ucSlaveDemod,
    u8        ucTuner2WireAddr,
    u8        ucStrong
)
{
    int tunerIdx=PDC->fc.tunerinfo.tunerIdx;
    u32   dwError = ERR_NO_ERROR;   
	ucSlaveDemod=0;
	ucDemod2WireAddr=0x3A;
	ucTuner2WireAddr=0xC0;


    if (tunerIdx < 0) {
        dwError = ERR_INVALID_TUNER_TYPE;        
        goto exit;    
    }
    
	dwError = AdjustFS803((Handle_t)1,ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, ucStrong);
    //dwError = TunerEntry[tunerIdx].Adjustfunc(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, ucStrong);
    if (dwError){
        deb_data("Adjust Tuner Fail");
    }
    
exit:
    return (dwError);    
}      

u32 DRV_CalibrateTuner(
    u8       ucDemod2WireAddr,
    u8       ucSlaveDemod,
    u8	    ucTuner2WireAddr,
    u32      f_in, 
    u32      f_out, 
    UData_t *    f_IF1, 
    SData_t *       P_max,
    void *      pf,
    void *      pp
)
{
    u32   dwError = ERR_NO_ERROR;   
    int tunerIdx = PDC->fc.tunerinfo.tunerIdx; 
	ucSlaveDemod=0;
	ucDemod2WireAddr=0x3A;
	ucTuner2WireAddr=0xC0;



    if (tunerIdx < 0) {
        dwError = ERR_INVALID_TUNER_TYPE;        
        goto exit;    
    }

	dwError = CalibrateFS803((Handle_t)1,ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, f_in, f_out, f_IF1, P_max, pf, pp);
    //dwError = TunerEntry[tunerIdx].Calibratefunc(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, f_in, f_out, f_IF1, P_max, pf, pp);
    if (dwError){
        deb_data("Calibrate Tuner Fail");
        goto exit;
    }
    
exit:
    return (dwError);    
} 


static u32 Af901xSetSysInfo (
    u8	ucDemod2WireAddr,
    u8	ucSlaveDemod,
    PSYS_INFO        pSys
)
{
    u32 dwError = ERR_NO_ERROR;
    u8	ucTemp;

	// get mode type
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_tpsd_const, reg_tpsd_const_pos, reg_tpsd_const_len, (u8)pSys->mod);
    if (dwError) goto exit;

	// get TPS hierachy and alpha value
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_tpsd_hier, reg_tpsd_hier_pos, reg_tpsd_hier_len, (u8)pSys->TpsHier);
    if (dwError) goto exit;

	// get high/low priority
    if (pSys->hplp == HPLP_HP)
    {
        ucTemp      = 1;
    }
    else
    {
        ucTemp      = 0;
    }
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_dec_pri, reg_dec_pri_pos, reg_dec_pri_len, ucTemp);
    if (dwError) goto exit;

	// get high code rate
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_tpsd_hpcr, reg_tpsd_hpcr_pos, reg_tpsd_hpcr_len, (u8)pSys->hpcr);
    if (dwError) goto exit;

	// get low code rate
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_tpsd_lpcr, reg_tpsd_lpcr_pos, reg_tpsd_lpcr_len, (u8)pSys->lpcr);
    if (dwError) goto exit;

	// get guard interval
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_tpsd_gi, reg_tpsd_gi_pos, reg_tpsd_gi_len, (u8)pSys->gi);
    if (dwError) goto exit;

    // get FFT mode
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_tpsd_txmod, reg_tpsd_txmod_pos, reg_tpsd_txmod_len, (u8)pSys->fft);
    if (dwError) goto exit;

	// get bw
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, g_reg_bw, reg_bw_pos, reg_bw_len, (u8)pSys->bw);
    if (dwError) goto exit;

exit:
    return(dwError);
}

static u32 Af901xSetFreq(
    u8	ucDemod2WireAddr,
    u8  ucSlaveDemod,
    u8  ucTuner2WireAddr,
    u32 dwFreq,            // KHz
    u8  ucBw,              // MHz
    PSYS_INFO  pSys        // null: for normal mode, non-null for easy mode
)
{
 
	#define   gdwOrigFCW       PDC->fc.gdwOrigFCW
	#define   gucOrigUnplugTh  PDC->fc.gucOrigUnplugTh
	#define   gucPreShiftIdx   PDC->fc.gucPreShiftIdx

    u32      dwError = ERR_NO_ERROR;
    u8       ucTemp;
    u8       ucTemp0;
    u8       ucTemp1;
    u8       ucTemp2;
    
    deb_data("%s\n",__FUNCTION__);
    deb_data("ucDemod2WireAddr=0x%X\n", ucDemod2WireAddr);
    deb_data("ucSlaveDemod=%d\n", ucSlaveDemod);   
    deb_data("ucTuner2WireAddr=0x%X\n", ucTuner2WireAddr);
    deb_data("dwFreq=%d\n", dwFreq); 
    deb_data("ucBw=%d\n", ucBw);

    ucTemp0 = (u8)(gdwOrigFCW  & 0x000000FF);
    ucTemp1 = (u8)((gdwOrigFCW & 0x0000FF00) >> 8);
    ucTemp2 = (u8)((gdwOrigFCW & 0x007F0000) >> 16);

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_bfs_fcw_7_0, ucTemp0);
    if (dwError) goto exit;
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_bfs_fcw_15_8, ucTemp1);
    if (dwError) goto exit;
    dwError = Af901xWriteReg( ucDemod2WireAddr, ucSlaveDemod, p_reg_bfs_fcw_22_16, ucTemp2);
    if (dwError) goto exit;


	// Clear easy mode flag first
	ucTemp = 0;
	dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAEFD, ucTemp);
	if (dwError) goto exit;

    // Clear MPEG2 lock flag
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, r_mp2if_sync_byte_locked, mp2if_sync_byte_locked_pos, mp2if_sync_byte_locked_len, 0x00);
    if (dwError) goto exit;

	if (pSys)
    {
		dwError = Af901xSetSysInfo(ucDemod2WireAddr, ucSlaveDemod, pSys);
        if (dwError) goto exit;

        dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, 0xAEFE, 0);
        if (dwError) goto exit;
    }

    dwError = SetTuner(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, dwFreq, ucBw);
    if (dwError) goto exit;

    //dwError = Af901xWriteReg(handle, ucDemod2WireAddr, ucSlaveDemod, p_dummy_reg_unplug_th, gucOrigUnplugTh[ucSlaveDemod]);
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_reg_unplug_th, gucOrigUnplugTh);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, AF901X_REG_TRIGGER_OFSM, 0);
    if (dwError)
    {
        goto exit;
    }

exit:
    //SysLeaveCriticalSection();
    return(dwError);
}

static u32 AdjustStrongSignal (
    u8 ucDemod2WireAddr,
    u8 ucSlaveDemod,
    u8 ucTuner2WireAddr
)
{
    u32 dwError = ERR_NO_ERROR;
    u8 ucTemp;

    dwError = Af901xReadRegBits(ucDemod2WireAddr, ucSlaveDemod, p_dummy_strong_signal_detected, dummy_strong_signal_detected_pos, dummy_strong_signal_detected_len, &ucTemp);
    if (dwError) goto exit;

    {            
        if (ucTemp)
        {                   
            AdjustTuner(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, 1);
        }               
        else
        {
            AdjustTuner(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, 0);
        }
    }


exit:

    return (dwError);
}

static u32 Af901xIsTPSLocked(
    u8 ucDemod2WireAddr,
    u8 ucSlaveDemod,
    u8 *bpLocked
)
{
    u32 dwError = ERR_NO_ERROR;
    u8	ucTemp;

    *bpLocked = 0;

    dwError = Af901xReadRegBits(ucDemod2WireAddr, ucSlaveDemod, p_fd_tpsd_lock, fd_tpsd_lock_pos, fd_tpsd_lock_len, &ucTemp);
    if (dwError) goto exit;

    if (ucTemp)
		*bpLocked =1;

exit:
	return(dwError);
}

u32 Af901xIsMpeg2Locked(
    u8 ucDemod2WireAddr,
    u8 ucSlaveDemod,
    u8 *bpLocked
)
{
    u32 dwError = ERR_NO_ERROR;
    u8	ucTemp;

    *bpLocked = 0;

    dwError = Af901xReadRegBits(ucDemod2WireAddr, ucSlaveDemod, r_mp2if_sync_byte_locked, mp2if_sync_byte_locked_pos, mp2if_sync_byte_locked_len, &ucTemp);
    if (dwError) goto exit;

    if (ucTemp) 
		*bpLocked = 1;

exit:
	return(dwError);
}

u32 DRV_Af901xSetFreq(
    u8 ucSlaveDemod,
    u32 dwFreq,
    u8 ucBw
)
{    
    u8 ucDemod2WireAddr = PDC->ucDemod2WireAddr =0x3A;
	u32  dwError = ERR_NO_ERROR; 
	int i;
    u8 ucTuner2WireAddr = 0xC0;
	u8 bLocked;
    u32 dwXtalFreq = XtalVal[PDC->fc.tunerinfo.XtalType]; 

    if(dwFreq)
        PDC->fc.ulDesiredFrequency = dwFreq;
    else
        dwFreq = PDC->fc.ulDesiredFrequency;

    if(ucBw)
        PDC->fc.ucDesiredBandWidth = ucBw;
    else
        ucBw = PDC->fc.ucDesiredBandWidth;
/*
    if ((dwFreq == PDC->fc.ulCurrentFrequency)&&(ucBw == PDC->fc.ucCurrentBandWidth)) { 
        printk(KERN_NOTICE"skip Af901xSetFreq\n");
        goto exit;
    }         

    if(PTI.bInitTuner){
        TUNER_KdPrint(("Skip SetFreq - Tuner is still off!"));
        goto exit;
    }
*/

    if (ucBw != PDC->fc.ucCurrentBandWidth) {
        PDC->fc.ucCurrentBandWidth = ucBw;
        dwError = Af901xSelectBW(ucDemod2WireAddr, ucSlaveDemod, ucBw, dwXtalFreq);
        if (dwError) goto exit;
    }
    //The value of input pSys with NULL is means normal mode, otherwise is easy mode
    PDC->fc.ulCurrentFrequency = dwFreq;
    dwError = Af901xSetFreq(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, dwFreq, ucBw, NULL);
    if (dwError) {
        deb_data("Af901xSetFreq Fail: 0x%04X\n", dwError); 
        goto exit;      
    }

    AdjustStrongSignal(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr);
    for (i=0; i<120; i++) {
        Af901xIsTPSLocked(ucDemod2WireAddr, ucSlaveDemod, &bLocked);
        if (bLocked) {
            deb_data("TPS Locked\n");    
            break; 
        }                         
        mdelay(10);
    }
    if (!bLocked)
        deb_data("TPS NOT Locked\n");
    if (bLocked) {
        AdjustStrongSignal(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr);
        for (i=0; i<220; i++) {
            Af901xIsMpeg2Locked(ucDemod2WireAddr, ucSlaveDemod, &bLocked);
            if (bLocked) {
                deb_data("MP2 Locked\n"); 
                break;     
            }                                               
            mdelay(10);
        }
        if (!bLocked)
            deb_data("MP2 NOT Locked\n");            
    }      
     
exit:      
    return(dwError); 
}

static u32 DRV_Af901xLoadTunerInitScript(
    u8  ucDemod2WireAddr,
    u8	ucSlaveDemod
)
{
    u32       dwError = ERR_NO_ERROR;
    int i,tunerIdx = PDC->fc.tunerinfo.tunerIdx;

    RegDesc *pInitScript = tuner_init_FreeScale_803A_EVB; 
    int initScriptNum = tuner_init_FreeScale_803A_EVB_NUM;

    //RegDesc *pInitScript = TunerEntry[tunerIdx].pInitScript; 
    //nt initScriptNum = TunerEntry[tunerIdx].initScriptNum;


    u32   addr;
    u8    pos;
    u8    len;
    u8    val;
/*
	if (tunerIdx < 0) {
        dwError = ERR_INVALID_TUNER_TYPE;        
        goto exit;    
    }
*/
    for(i=0; i<initScriptNum; i++)
    {
        addr = pInitScript[i].regAddr;
        pos = pInitScript[i].regPos;
        len = pInitScript[i].regLen;
        val = pInitScript[i].regVal;

        //TUNER_KdPrint(("0x%04X, 0x%02X, 0x%02X, 0x%02X", addr, pos, len, val));       

        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, addr, pos, len, val);
        if (dwError) goto exit;
    }

exit:
    return (dwError);
}    

static u32 Af901xInit(
    u8       ucDemod2WireAddr,
    u8       ucSlaveDemod,
    u8       ucBw,                   // MHz
    u32      dwFs,                   // KHz
    u32      dwIfFreq,               // KHz
    u8       ucSpecInv,
	u8       ucOutputMode,
	u8       ucTuner2WireAddr,
	void *   pTunerData
)
{
    u32 dwError = ERR_NO_ERROR;
    u8    i;
    u8    len;
	#define   gucOrigUnplugTh  PDC->fc.gucOrigUnplugTh

    deb_data("enter Af901xInit\n");
    deb_data("ucDemod2WireAddr=0x%X\n", ucDemod2WireAddr);
    deb_data("ucSlaveDemod=%d\n", ucSlaveDemod);
    deb_data("ucBw=%d\n", ucBw);
    deb_data("dwFs=%d\n", dwFs);
    deb_data("dwIfFreq=0x%X\n", dwIfFreq);
    deb_data("ucSpecInv=%d\n", ucSpecInv);

    // Enable ADC
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_reg_afe_mem0, 0xA4);
    if (dwError) goto exit;

    // Write API version to fw
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_api_ver_0, AF901X_API_VER_0);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_api_ver_1, AF901X_API_VER_1);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_api_ver_2, AF901X_API_VER_2);
    if (dwError) goto exit;

    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, p_dummy_api_ver_3, AF901X_API_VER_3);
    if (dwError) goto exit;

    // Compute FCW and ADC and load them to device
    
    dwError = Af901xLoadFcwAdc(ucDemod2WireAddr, ucSlaveDemod, (int)dwFs, (int)dwIfFreq, ucSpecInv);
    if (dwError) goto exit;

    // set I2C master clock to 0x14 (for 60KHz)
    dwError = Af901xWriteReg(ucDemod2WireAddr, ucSlaveDemod, I2C_i2c_m_period, 0x14);
    if (dwError) goto exit;

	// set 16 tBYTE embx
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_reg_i2c_16_8_data_sel, reg_i2c_16_8_data_sel_pos, reg_i2c_16_8_data_sel_len, 1);
    if (dwError) goto exit;

	// set no trigger
	dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_reg_i2c_slave_trigger_byte, reg_i2c_slave_trigger_byte_pos, reg_i2c_slave_trigger_byte_pos, 0);
    if (dwError) goto exit;

    dwError = Af901xSelectBW(ucDemod2WireAddr, ucSlaveDemod, ucBw, dwFs);
    if (dwError) goto exit;

    
    if (ucOutputMode == AF901X_OUTPUT_USB_OUTPUT)
    {
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_mp2if_mpeg_ser_mode, mp2if_mpeg_ser_mode_pos, mp2if_mpeg_ser_mode_len, 0);
		if (dwError) goto exit;
        
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_mp2if_mpeg_par_mode, mp2if_mpeg_par_mode_pos, mp2if_mpeg_par_mode_len, 0);
		if (dwError) goto exit;        
    }
    else
    {
        if (ucOutputMode == AF901X_OUTPUT_MPEG_SERIAL)
	    {
		    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_mp2if_mpeg_ser_mode, mp2if_mpeg_ser_mode_pos, mp2if_mpeg_ser_mode_len, 1);
		    if (dwError) goto exit;
	    }
	    else
	    {
		    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_mp2if_mpeg_ser_mode, mp2if_mpeg_ser_mode_pos, mp2if_mpeg_ser_mode_len, 0);
		    if (dwError) goto exit;

            dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_mp2if_mpeg_par_mode, mp2if_mpeg_par_mode_pos, mp2if_mpeg_par_mode_len, 1);
		    if (dwError) goto exit;
	    }
    }

	// set read-update bit to 1 for constellation
    dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, p_reg_feq_read_update, reg_feq_read_update_pos, reg_feq_read_update_len, 1);
    if (dwError) goto exit;

    // Enable FEC Monitor
    dwError = Af901xEnableFecMon(ucDemod2WireAddr, ucSlaveDemod);
    if (dwError) goto exit;    

    // Load OFSM init script
	len = sizeof(ofsm_init) / sizeof(RegDesc);
    for (i = 0; i < len; i++)
    {
        dwError = Af901xWriteRegBits(ucDemod2WireAddr, ucSlaveDemod, ofsm_init[i].regAddr, ofsm_init[i].regPos, ofsm_init[i].regLen, ofsm_init[i].regVal);
        if (dwError) goto exit;
    }

    // Load Tuner init script
    dwError = LoadTunerInitScript(ucDemod2WireAddr, ucSlaveDemod);
    if (dwError) goto exit;

	// Init Tuner Now

    dwError = InitTuner(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, pTunerData);
	if (dwError) goto exit;

    //dwError = Af901xReadRegBits(handle, ucDemod2WireAddr, ucSlaveDemod, p_dummy_reg_unplug_th, dummy_reg_unplug_th_pos, dummy_reg_unplug_th_len, &gucOrigUnplugTh[ucSlaveDemod]);

	dwError = Af901xReadRegBits(ucDemod2WireAddr, ucSlaveDemod, p_dummy_reg_unplug_th, dummy_reg_unplug_th_pos, dummy_reg_unplug_th_len, &gucOrigUnplugTh);
    if (dwError) goto exit;
    
exit:
    return (dwError);
}


static u32 DRV_Af901xInit(u8 tmp)
{

    u32	dwError = ERR_NO_ERROR;
	u8  ucSlaveDemod=0;
    u8	ucDemod2WireAddr = PDC->ucDemod2WireAddr;
    u32 dwFs = XtalVal[PDC->fc.tunerinfo.XtalType];
    u8	ucTuner2WireAddr = 0xC0;
    u32 pTunerData = PDC->fc.tunerinfo.wIf1;//1220;

    u8  bIfSpecInv = PDC->fc.tunerinfo.TunerId&0x80?1:0;
    u8  ucSpecInv =PDC->fc.tunerinfo.bRdSpecInv^bIfSpecInv;
    u32 dwIfFreq = PDC->fc.tunerinfo.wIfFreq;//36125;
    u8  bw = 6;

    if(ucSlaveDemod)
        dwError = Af901xInit(ucDemod2WireAddr, ucSlaveDemod, bw, dwFs, dwIfFreq, ucSpecInv, AF901X_OUTPUT_MPEG_SERIAL, ucTuner2WireAddr, &pTunerData);        
    else
        dwError = Af901xInit(ucDemod2WireAddr, ucSlaveDemod, bw, dwFs, dwIfFreq, ucSpecInv, AF901X_OUTPUT_USB_OUTPUT, ucTuner2WireAddr, &pTunerData);        

  if (dwError) goto exit; 

exit:      
    return(dwError); 
}


u32 DL_ApCtrl(u8 bOn)
{
    //ENTER_MUTEX();   

    u32 dwError = ERR_NO_ERROR;


    dwError = DRV_TunerPowerCtrl(bOn);
    if(dwError) goto exit; 

    dwError = DRV_Lock1LedCtrl(bOn);
    if(dwError) goto exit; 

    //If not support suspend of EEPROM Setting, use ApOff to save power
    //if(!PDC->bSupportSelSuspend){
	dwError = Af901xSwPowerCtrl(bOn);
    if (dwError) goto exit;  

    if (bOn) dwError = DRV_Af901xInit(1);

exit:     
    //LEAVE_MUTEX();    
    return(dwError);
}
EXPORT_SYMBOL(DL_ApCtrl);


int Afa901x_usb_init(struct usb_device *udev,PDEVICE_CONTEXT PDCs)
{
    u32 fwVer;
	s32 ucConfig;
	u32 dwError=1;
    u8  ucDemod2WireAddr = 0;

	udevs=udev;
	PDC=PDCs;

	PDC->MaxPacketSize=0x0200;
	PDC->TsFrameSize=0x0200 * 188;
	PDC->TsFrameSizeDw=((0x0200 * 188 )/4);

	deb_data("Afa901x_usb_init()\n");

	dwError=DL_GetEEPROMConfig(1);

	//DownloadFW	
    dwError = USB_GetCurrConfig(&ucConfig);

	if (dwError) {
       	deb_data("USB_GetCurrConfig fail\n"); 
       	goto exit;
    }

    deb_data("ucConfig = 0x%x\n", ucConfig);
    //PDC.bBootCode = (ucConfig == 1 && bBoot);
    //CAP_KdPrint(("bBootCode = %s", PDC->bBootCode?"true":"false"));    
    if (ucConfig != 1)
    {    
        printk(KERN_NOTICE"15 FW exists");        
        
        dwError = DRV_GetFwVersions(&fwVer);
        if (dwError) {
            deb_data("DRV_GetFwVersions failed, 0x%X", dwError);
            goto exit;
        }    
        deb_data("FW Version = 0x%X", fwVer);

        if (fwVer == FW_VER) {
            dwError = ERR_NO_ERROR;        
            goto exit;
        }

        dwError = USB_ReDownloadFw(1);
        if (dwError) {
            deb_data("USB_ReDownloadFw failed, 0x%X", dwError);
            goto exit;
        }
		mdelay(10);  //Wait a little time for FW boot code done
        //If the FW doesn't disconnect and return to boot code
        //GetConfig command should be success
        dwError = USB_GetCurrConfig( &ucConfig);
        if(dwError){
            deb_data("USB_ReDownloadFw: USB_GetCurrConfig fail: 0x%X", dwError); 
            goto exit;
        }
    }

	dwError = Af901xLoadFW(ucDemod2WireAddr);        
    if (dwError) {
        deb_data("USB20_LoadFWs failed\n");
        goto exit;
    }

    dwError = DRV_GetFwVersions(&fwVer);  
    if (dwError) {
        deb_data("DRV_GetFwVersions failed\n");
        goto exit;
    }

	deb_data("FW Version = 0x%X\n", fwVer);

    dwError = DL_MercuryInit(1);
    if (dwError)
	{	
        deb_data("DL_MercuryInit fail\n");
		goto exit;
	}

	dwError = DL_ApCtrl(0);
    if (dwError)
	{	
        deb_data("DL_ApCtrl fail\n");
		goto exit;
	}

exit:
    return (dwError);

}
EXPORT_SYMBOL(Afa901x_usb_init);


extern u32 Af901xWriteTunerRegs(
    u8    ucDemod2WireAddr,
    u8    ucSlaveDemod,
    u8    ucTuner2WireAddr,
    u8    ucTunerType,
    u16   wRegAddr,
    u8    ucCount,
    u8 *  ucpBuf
)
{
    u32   dwError = ERR_NO_ERROR;
    
    //SysEnterCriticalSection();

    dwError = USB_WriteTunerRegs(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, ucTunerType, wRegAddr, ucCount, ucpBuf);
    if(dwError)
        deb_data("Af901xWriteTunerRegs fail, 0x%04X\n",dwError);

    //SysLeaveCriticalSection();
    
    return (dwError);
}

u32 Af901xReadTunerRegs(
    u8 ucDemod2WireAddr,
    u8 ucSlaveDemod,
    u8 ucTuner2WireAddr,
    u8 ucTunerType,
    u16 wRegAddr,
    u8 ucCount,
    u8 *  ucpBuf
)
{
    u32   dwError = ERR_NO_ERROR;
    
    //SysEnterCriticalSection();

    dwError = USB_ReadTunerRegs(ucDemod2WireAddr, ucSlaveDemod, ucTuner2WireAddr, ucTunerType, wRegAddr, ucCount, ucpBuf);

    //SysLeaveCriticalSection();
    
    return (dwError);
}

u32 Af901xGetIFAGC(
	u8	ucDemod2WireAddr,
    u8  ucSlaveDemod,
    u8 *ucpGain
)
{
    u32	dwError = ERR_NO_ERROR;
    u8	ucTemp;

    // get rf_agc_control
    dwError = Af901xReadRegBits(ucDemod2WireAddr, ucSlaveDemod, r_reg_aagc_if_gain, reg_aagc_if_gain_pos, reg_aagc_if_gain_len, &ucTemp);
    if (dwError) goto exit;

    *ucpGain = ucTemp;

exit:
    return(dwError);
}



u32 Do_Tuner_Init(u8 tmp)
{


    u32 dwError = DL_MercuryInit(1);
    if (dwError) goto exit;

	dwError = DL_ApCtrl(1);
    if (dwError) goto exit;

exit:
    return (dwError);
}
EXPORT_SYMBOL(Do_Tuner_Init);

u32 Do_Tuner_SetBW(u8 ucBw)
{
    u32 dwFs = XtalVal[PDC->fc.tunerinfo.XtalType]; 
	return Af901xSelectBW(0x3A,0,ucBw,dwFs);

}
EXPORT_SYMBOL(Do_Tuner_SetBW);

u32 Do_Tuner_SetFreq(u32 dwFreq,u8 ucBw)
{

	return DRV_Af901xSetFreq(0,dwFreq,ucBw);
	
}
EXPORT_SYMBOL(Do_Tuner_SetFreq);

u32 FS803_Set(u32 dwFreq,u8 ucBw)
{
	return SetFS803((Handle_t)1,0x3A,0,0xC0,dwFreq,ucBw);
}
EXPORT_SYMBOL(FS803_Set);

u32 FS803_Calibrate(u8 tmp)
{
    UData_t*    f_IF1=NULL;
    SData_t*    P_max=NULL;
    void *      pf=NULL;
    void *      pp=NULL;
	return CalibrateFS803((Handle_t)1,0x3A,0,0xC0, 666000000,36125000, f_IF1,P_max,pf, pp);
}
EXPORT_SYMBOL(FS803_Calibrate);
